program Project17;

{$APPTYPE CONSOLE}

{$R *.res}

uses
  System.SysUtils,
  VCL.FlexCel.Core,
  FlexCel.XlsAdapter;

function CalcImgSize(const xls: TExcelFile; const row1, col1, col2: integer; const filename: string): IImageProperties;
var
  imgHeight: Int32;
  imgWidth: Int32;
  Img: TUIImage;
  CorrectedImgWidth, CorrectedImgHeight: Int32;
  hCells, wCells: double;
  Anchor, FinalAnchor: TClientAnchor;
begin
  Anchor := TClientAnchor.Create(TFlxAnchorType.MoveAndDontResize, 1, 0, col1, 0, 2, 0, col2, 0);
  Anchor.CalcImageCoords(hCells, wCells, xls);
  Img := TUIImage.FromFile(filename);
  try
    imgHeight := Trunc(((Img.HeightInPoints * 96.0) / 72.0));
    imgWidth := Trunc(((Img.WidthInPoints * 96.0) / 72.0));

    CorrectedImgWidth := Round(wCells);
    CorrectedImgHeight := Round(imgHeight * wCells / ImgWidth);

    FinalAnchor := TClientAnchor.Create(TFlxAnchorType.MoveAndDontResize, row1, 0, col1, 0, CorrectedImgHeight, CorrectedImgWidth, xls);
    Result := TImageProperties_Create(
              TClientAnchor.Create(TFlxAnchorType.MoveAndDontResize, row1, 0, col1, 0, FinalAnchor.Row2, FinalAnchor.Dy2, col2, 0),
              '');
  finally
    Img.Free;
  end;

end;

var
  xls: TExcelFile;
const
  filename = '..\..\plane.png';
begin
  xls := TXlsFile.Create(1, TExcelFileFormat.v2016, true);
  try
    xls.DefaultRowHeight := 500;
    xls.DefaultRowHeightAutomatic := false;
    xls.SetRowHeight(2, 50);
    xls.SetRowHeight(3, 1000);
    xls.SetRowHeight(3, 2000);
    xls.AddImage(filename, CalcImgSize(xls, 2, 3, 7, filename));
    xls.Save('..\..\testresult.xlsx');

    xls.SetRowHeight(2, 250);

    xls.Save('..\..\testresult2.xlsx');
  finally
    xls.Free;
  end;
end.
