unit UAltTabDlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ImgList;

type
  TAltTabDlg = class(TForm)
    StatusBar: TStatusBar;
    ListView: TListView;
    ImageList2: TImageList;
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ListViewChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{$R *.dfm}

procedure TAltTabDlg.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key<>VK_TAB)and not ((Key>=32)and (key<128)) then ModalResult:=mrOk;
end;

procedure TAltTabDlg.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_TAB then
    if ListView.ItemIndex<ListView.Items.Count-1 then ListView.ItemIndex:=ListView.ItemIndex+1
    else ListView.ItemIndex:=0
  else
  if (Key>=32)and (key<128) then
    if ListView.ItemIndex>0 then ListView.ItemIndex:=ListView.ItemIndex-1
    else ListView.ItemIndex:=ListView.Items.Count-1;
end;

procedure TAltTabDlg.ListViewChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  if Item.SubItems.Count>0 then StatusBar.SimpleText:=Item.SubItems.Strings[0];
  Item.MakeVisible(false);
end;

end.
