unit UAltTab;

interface
procedure Register;

implementation

uses Windows, Forms, Classes, SysUtils, ToolsAPI, Controls, Menus, UAltTabDlg, ComCtrls;
type
  TAltTabList = class(TNotifierObject, IUnknown, IOTANotifier,
    IOTAKeyboardBinding)
    procedure AltTabListProc(const Context: IOTAKeyContext; KeyCode: TShortCut;
      var BindingResult: TKeyBindingResult);
    function GetBindingType: TBindingType;
    function GetDisplayName: string;
    function GetName: string;
    procedure BindKeyboard(const BindingServices: IOTAKeyBindingServices);
  end;

resourcestring
  sAltTabList = 'Ctrl-Alt-Tab List';

procedure Register;
begin
  (BorlandIDEServices as IOTAKeyBoardServices).AddKeyboardBinding(TAltTabList.Create);
end;

{ TAltTabList }

procedure TAltTabList.AltTabListProc(const Context: IOTAKeyContext;
  KeyCode: TShortCut; var BindingResult: TKeyBindingResult);
var
  I: Integer;
  InterfaceList: IInterfaceList;
  Iter: IOTAEditBufferIterator;
  Buffer: IOTAEditBuffer;
  AltTabDlg: TAltTabDlg;
  Li: TListItem;
begin
  AltTabDlg:=TAltTabDlg.Create(Application);
  try
    InterfaceList := TInterfaceList.Create;
    Context.KeyboardServices.EditorServices.GetEditBufferIterator(Iter);
    for I := 0 to Iter.Count - 1 do
    begin
      Buffer := Iter.EditBuffers[I];
      InterfaceList.Add(Buffer);
      Li:=AltTabDlg.ListView.Items.Add;
      Li.Caption:=ExtractFileName(Buffer.FileName);
      if Buffer.Module.ModuleFileCount>1 then Li.ImageIndex:=0 else Li.ImageIndex:=1;
      Li.SubItems.Add(Buffer.FileName)
    end;
    Iter := nil;

    if AltTabDlg.ListView.Items.Count > 1 then
    begin
      AltTabDlg.ListView.ItemIndex:=1;
      if AltTabDlg.ShowModal = mrOK then
      (InterfaceList[AltTabDlg.ListView.ItemIndex] as IOTAEditBuffer).Show;
    end;
  finally
    AltTabDlg.Free;
  end;
  BindingResult := krHandled;
end;

procedure TAltTabList.BindKeyboard(
  const BindingServices: IOTAKeyBindingServices);
begin
  BindingServices.AddKeyBinding([ShortCut(VK_TAB, [ssCtrl, ssAlt])], AltTabListProc, nil);
end;

function TAltTabList.GetBindingType: TBindingType;
begin
  Result := btPartial;
end;

function TAltTabList.GetDisplayName: string;
begin
  Result:=sAltTabList;
end;

function TAltTabList.GetName: string;
begin
  Result := 'Adrian.AltTabList';  //do not localize
end;

end.
 